using UnityEngine;
using System.Collections;

public class s_PlatformTime : s_Platform
{
	public Texture2D jumpableTexture;
	public Texture2D unjumpableTexture;
	public int totalTurns = 0;
	public int offOnTurn = 0;
	public int turnsOff = 0;
	
	public int prevTurn = 1;
	public int trackTurn = 1;
	public int offCounter = 0;
	public bool jumpEnabled;
	
	bool hitPlayer = false; //Checks if you hit the player so you don't change to off texture
	
	void Start()
	{
		trackTurn = 1; //Start at 1
		offCounter = turnsOff;
	}
	
	// Update is called once per frame
	void Update()
	{
		if (prevTurn != s_Player.turn)
		{	
			
			if (trackTurn >= offOnTurn)
			{
				//Change the picture, and make it unclickable
				
				
				//transform.Translate(Vector3.up * 10000);
				//collider.enabled = false;
				jumpEnabled = true;
				//transform.Translate(Vector3.up * -10000);
				
				//StartCoroutine(EnableCollider());
				
				renderer.material.mainTexture = jumpableTexture;
				//StartCoroutine(DisableCollider());
				//renderer.material.color = Color.red;
			}
			
			if (trackTurn > offOnTurn)
			{
				--offCounter;
				
				if (offCounter <= 0)
				{
					offCounter = turnsOff;
					//Change the picture, make it clickable
					
					
					//transform.Translate(Vector3.up * 10000);
					//collider.enabled = true;
					//transform.Translate(Vector3.up * -10000);
					
					jumpEnabled = false;
					//StartCoroutine(EnableCollider());
					
					if (!hitPlayer)
						renderer.material.mainTexture = unjumpableTexture;
					//renderer.material.color = Color.green;
				}
			}
			prevTurn = s_Player.turn;
			++trackTurn;
			
			if (trackTurn > totalTurns)
				trackTurn = 1;
			
			if (hitPlayer)
				hitPlayer = false;
			
		}
	}
	
	override public void Hit()
	{}
	
	void OnTriggerEnter(Collider other)
	{
		if (other.gameObject.name == "Player")
			hitPlayer = true;
	}
}